/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DPCDCommandType;
import com.quantumdata.busmon.parser.DPCDMessage;
import com.quantumdata.busmon.parser.DPCDMessageType;
import com.quantumdata.busmon.parser.DPCDReplyMessage;
import com.quantumdata.busmon.parser.DPCDRequestMessage;
import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.DisplayPortDirection;
import com.quantumdata.busmon.parser.TypeConverter;
import java.util.StringTokenizer;

public class DPCDDataBlock
extends DataBlock {
    private static final int NATIVE_GET_COMMAND = 1;
    private static final int NATIVE_READ_REQUEST_ADDRESS = 2;
    private static final int NATIVE_READ_REQUEST_DATA_LENGTH = 3;
    private static final int NATIVE_READ_REQUEST_DATA_BYTES = 4;
    private static final int NATIVE_READ_REPLY_DATA_BYTES = 5;
    private static final int NATIVE_READ_REPLY_DATA_BYTE_M = 6;
    private static final int I2C_OVER_AUX_GET_REQUEST_COMMAND = 7;
    private static final int I2C_OVER_AUX_GET_REQUEST_ADDRESS = 8;
    private static final int I2C_OVER_AUX_GET_REQUEST_DATA_LENGTH = 9;
    private static final int I2C_OVER_AUX_GET_REQUEST_DATA_BYTES = 10;
    private static final int I2C_OVER_AUX_GET_REPLY_COMMAND = 11;
    private static final int I2C_OVER_AUX_GET_REPLY_BYTES = 12;
    private static final int DONE = 13;
    private static final int ERROR = 14;
    private static final byte AUX_RESERVED = 3;
    private static final byte AUX_DEFER = 2;
    private static final byte AUX_NACK = 1;
    private static final byte AUX_ACK = 0;
    private static final byte READ = 9;
    private static final byte I2C_OVER_AUX_REQUEST_MOT_MASK = 64;
    private static final byte I2C_OVER_AUX_REQUEST_MOT = 64;
    private static final byte I2C_OVER_AUX_REQUEST_MASK = 48;
    private static final byte I2C_OVER_AUX_REQUEST_WRITE = 0;
    private static final byte I2C_OVER_AUX_REQUEST_READ = 16;
    private static final byte I2C_OVER_AUX_REQUEST_STATUS_UPDATE_REQUEST = 32;
    private static final byte I2C_OVER_AUX_REQUEST_RESERVED = 48;
    private static final short I2C_OVER_AUX_REPLY_MASK = 192;
    private static final short I2C_OVER_AUX_REPLY_I2C_ACK = 0;
    private static final short I2C_OVER_AUX_REPLY_I2C_NACK = 64;
    private static final short I2C_OVER_AUX_REPLY_I2C_DEFER = 128;
    private static final short I2C_OVER_AUX_REPLY_I2C_RESERVED = 192;
    private static int PADDING = 2;
    protected static DPCDDataBlock sLastBlock = null;
    private int aState = 1;
    private StringBuffer aStateMachineTransitions;
    private String aExplanation = "";
    private String aMessageParsedDetail = "";
    protected long aTimestamp;
    protected long aPreviousBlockTimestamp;
    protected int aSourceID;
    protected DisplayPortDirection aDirection;
    protected DPCDMessage aMessage;
    protected Integer[] aRawPacket;
    protected static boolean sIsMOT = false;
    protected boolean aNative = false;
    protected boolean aErrorDataBlock;
    private static int[] sVH = new int[5];
    private static int sR0 = 0;

    public DPCDDataBlock(Integer[] integerArray) {
        this.aRawPacket = (Integer[])integerArray.clone();
        this.aSourceID = integerArray[7];
        this.aDirection = integerArray[8] == 1 ? DisplayPortDirection.MASTER_TO_SLAVE : DisplayPortDirection.SLAVE_TO_MASTER;
        this.aTimestamp = TypeConverter.composeLong(integerArray, 9);
        this.aPreviousBlockTimestamp = sLastBlock == null ? 0L : sLastBlock.getTimestamp();
        this.aNative = false;
        this.aMessage = null;
        this.aErrorDataBlock = false;
        this.aStateMachineTransitions = new StringBuffer("");
        this.aStateMachineTransitions.append("Initial State             Data Byte     Next State\n");
        this.parse(integerArray);
        sLastBlock = this;
    }

    public String getHexRepresentation(Integer[] integerArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (integerArray != null && integerArray.length != 0) {
            int n;
            int n2;
            stringBuffer.append(String.format("Length: %d bytes\n\n", integerArray.length));
            stringBuffer.append("Addr  Data Bytes (Hex)           ASCII Representation\n");
            boolean bl = false;
            for (n2 = 0; n2 < integerArray.length; ++n2) {
                Integer n3 = integerArray[n2];
                if (n2 % 8 == 0) {
                    bl = true;
                }
                if (bl && n2 != 0) {
                    for (n = 0; n < 7 - (n2 - 1) % 8; ++n) {
                        stringBuffer2.append("   ");
                        stringBuffer3.append("  ");
                    }
                    if (stringBuffer2 != null) {
                        stringBuffer.append(stringBuffer2);
                    }
                    if (stringBuffer3 != null) {
                        stringBuffer.append(" | ");
                        stringBuffer.append(stringBuffer3);
                    }
                    stringBuffer.append('\n');
                    stringBuffer2 = new StringBuffer();
                    stringBuffer3 = new StringBuffer();
                }
                if (bl) {
                    stringBuffer.append(String.format("%04X  ", n2));
                    for (n = 0; n < n2 % 8; ++n) {
                        stringBuffer2.append("   ");
                        stringBuffer3.append("  ");
                    }
                    bl = false;
                }
                stringBuffer2.append(String.format("%02X ", n3));
                if (n3 > 32 && n3 < 127) {
                    stringBuffer3.append(String.format("%c ", n3));
                    continue;
                }
                stringBuffer3.append(". ");
            }
            for (n = 0; n < 7 - (n2 - 1) % 8; ++n) {
                stringBuffer2.append("   ");
                stringBuffer3.append("  ");
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer3 != null) {
                stringBuffer.append(" | ");
                stringBuffer.append(stringBuffer3);
            }
        } else {
            stringBuffer.append("No datablock contents.");
        }
        return stringBuffer.toString();
    }

    private void parse(Integer[] integerArray) {
        int n = integerArray[13];
        if (this.aDirection == DisplayPortDirection.MASTER_TO_SLAVE) {
            if ((n & 0x80) == 128) {
                this.aNative = true;
                this.aState = 1;
                this.parseNative(integerArray);
            } else {
                this.aState = 7;
                this.parseNonNativeRequest(integerArray);
            }
        } else {
            if (n == 0) {
                if (DPCDDataBlock.wasLastBlockNative()) {
                    this.aNative = true;
                    this.aState = 1;
                    this.parseNative(integerArray);
                } else {
                    this.aState = 11;
                    this.parseNonNativeReply(integerArray);
                }
            } else if ((n & 0xC0) == 0) {
                this.aNative = true;
                this.aState = 1;
                this.parseNative(integerArray);
            } else {
                this.aState = 11;
                this.parseNonNativeReply(integerArray);
            }
            long l = this.aTimestamp - this.aPreviousBlockTimestamp;
            if (l > 300L) {
                StringBuffer stringBuffer = new StringBuffer("");
                stringBuffer.append("Timestamp of this   Reply Message:  " + this.aTimestamp + "\n");
                stringBuffer.append("Timestamp of last Request Message:  " + this.aPreviousBlockTimestamp + "\n");
                stringBuffer.append("Difference:  " + l + "\n");
                this.aExplanation = stringBuffer.toString();
                this.aErrorDataBlock = true;
            }
        }
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Timing Information\n");
        stringBuffer.append("------------------\n");
        stringBuffer.append("Time since last reset:  " + TypeConverter.getTimestampString(this.aTimestamp) + "\n");
        stringBuffer.append("Total Time From Last Received Message:  ");
        stringBuffer.append(TypeConverter.getTimeString(this.aTimestamp - this.aPreviousBlockTimestamp) + "\n\n");
        if (this.isError()) {
            stringBuffer.append("Error Information\n");
            stringBuffer.append("-----------------\n");
            String string = "No Error Information Available\n";
            if (!this.aExplanation.equalsIgnoreCase("")) {
                string = this.aExplanation;
            }
            stringBuffer.append(string + "\n");
        }
        stringBuffer.append("DPCD Message Details\n");
        stringBuffer.append("---------------------\n");
        if (this.aMessage != null) {
            stringBuffer.append(this.aMessage.getDetails() + "\n\n");
            if (!this.aMessageParsedDetail.equalsIgnoreCase("")) {
                stringBuffer.append(this.aMessageParsedDetail);
            }
        } else {
            stringBuffer.append("This datablock does not contain a completed message.\n\n");
        }
        return stringBuffer.toString();
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.aMessage != null) {
            stringBuffer.append(this.aMessage.getCommandTypeText());
            if (this.aMessage.getMessageType() == DPCDMessageType.READ_REQUEST) {
                DPCDRequestMessage dPCDRequestMessage = (DPCDRequestMessage)this.aMessage;
                stringBuffer.append(" " + dPCDRequestMessage.getDataLength() + " Bytes");
            } else {
                String string = DataBlock.getMessageDataAsHexString(this.aMessage);
                if (!string.equalsIgnoreCase("")) {
                    stringBuffer.append(" " + string);
                }
            }
        } else if (this.aRawPacket != null) {
            stringBuffer.append("Incomplete Message");
        }
        return stringBuffer.toString();
    }

    public String getType() {
        String string = "UNDEFINED";
        if (this.aMessage != null) {
            string = this.aMessage.getMessageTypeText();
        }
        return string;
    }

    public boolean isError() {
        boolean bl = this.aErrorDataBlock;
        if (this.aMessage != null) {
            bl |= this.aMessage.isError();
        }
        return bl;
    }

    private static String makeDisplayString(int n, int n2, int n3) {
        return DPCDDataBlock.getFormattedStateText(n) + DPCDDataBlock.getDataValueAsHexString(n2) + DPCDDataBlock.getFormattedStateText(n3) + "\n";
    }

    private void parseNative(Integer[] integerArray) {
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        block14: for (int i = 13; i < integerArray.length && this.aState != 14; ++i) {
            int n3 = integerArray[i];
            switch (this.aState) {
                case 1: {
                    Object object;
                    Enum enum_;
                    by = (byte)((n3 & 0xF0) >> 4);
                    if ((by & 8) == 8) {
                        by2 = (byte)(n3 & 0xF);
                        this.aState = 2;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                        continue block14;
                    }
                    DPCDMessageType dPCDMessageType = this.getLastMessageType();
                    switch (dPCDMessageType) {
                        case REPLY_TO_READ_REQUEST: 
                        case REPLY_TO_WRITE_REQUEST: {
                            this.aState = 14;
                            this.aErrorDataBlock = true;
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                            break;
                        }
                        case READ_REQUEST: {
                            if (by == 3 || by == 1) {
                                if (by == 3) {
                                    this.aExplanation = "AUX_RESERVED is an Illegal Reply Command Type\n";
                                } else if (by == 1) {
                                    this.aExplanation = "AUX_NACK is an Illegal Reply Command Type to a Previous Read Request Message\n";
                                }
                                this.aState = 14;
                                this.aErrorDataBlock = true;
                                this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                                break;
                            }
                            if (by == 2) {
                                enum_ = DPCDMessageType.REPLY_TO_READ_REQUEST;
                                DPCDCommandType dPCDCommandType = DPCDCommandType.AUX_DEFER;
                                object = new DPCDReplyMessage((DPCDMessageType)enum_, dPCDCommandType);
                                this.aMessage = object;
                                this.aState = 13;
                                this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                                break;
                            }
                            if (by == 0) {
                                if (i + 1 < integerArray.length) {
                                    n2 = integerArray.length - (i + 1);
                                    byArray = new byte[n2];
                                    n = 0;
                                    this.aState = 5;
                                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                                    break;
                                }
                                enum_ = DPCDMessageType.REPLY_TO_READ_REQUEST;
                                DPCDCommandType dPCDCommandType = DPCDCommandType.AUX_ACK;
                                object = new DPCDReplyMessage((DPCDMessageType)enum_, dPCDCommandType);
                                this.aMessage = object;
                                this.aState = 13;
                                this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                                break;
                            }
                            this.aState = 14;
                            this.aExplanation = "Undefined Command Type for this Message\n";
                            this.aErrorDataBlock = true;
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                            break;
                        }
                        case WRITE_REQUEST: {
                            if (by == 3) {
                                this.aState = 14;
                                this.aExplanation = "AUX_RESERVED is an Illegal Reply Command Type\n";
                                this.aErrorDataBlock = true;
                                this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                                break;
                            }
                            if (by == 2) {
                                enum_ = DPCDMessageType.REPLY_TO_WRITE_REQUEST;
                                DPCDCommandType dPCDCommandType = DPCDCommandType.AUX_DEFER;
                                object = new DPCDReplyMessage((DPCDMessageType)enum_, dPCDCommandType);
                                this.aMessage = object;
                                this.aState = 13;
                                this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                                break;
                            }
                            if (by == 1) {
                                this.aState = 6;
                                this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                                break;
                            }
                            if (by == 0) {
                                enum_ = DPCDMessageType.REPLY_TO_WRITE_REQUEST;
                                DPCDCommandType dPCDCommandType = DPCDCommandType.AUX_ACK;
                                object = new DPCDReplyMessage((DPCDMessageType)enum_, dPCDCommandType);
                                this.aMessage = object;
                                this.aState = 13;
                                this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                                break;
                            }
                            this.aState = 14;
                            this.aExplanation = "Undefined Command Type for this Message\n";
                            this.aErrorDataBlock = true;
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(1, n3, this.aState));
                        }
                    }
                    continue block14;
                }
                case 2: {
                    if (!bl) {
                        by3 = (byte)n3;
                        bl = true;
                        this.aState = 2;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(2, n3, this.aState));
                        continue block14;
                    }
                    by4 = (byte)n3;
                    this.aState = 3;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(2, n3, this.aState));
                    continue block14;
                }
                case 3: {
                    Object object;
                    Enum enum_;
                    n2 = n3 + 1;
                    DPCDMessageType dPCDMessageType = (by & 9) == 9 ? DPCDMessageType.READ_REQUEST : DPCDMessageType.WRITE_REQUEST;
                    Enum enum_2 = enum_ = (by & 9) == 9 ? DPCDCommandType.READ : DPCDCommandType.WRITE;
                    if (dPCDMessageType == DPCDMessageType.READ_REQUEST) {
                        if (n2 > 16) {
                            this.aState = 14;
                            this.aExplanation = "Message Data Length of " + n2 + " exceeds maximum of 16 allowed\n";
                            this.aErrorDataBlock = true;
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(3, n3, this.aState));
                            continue block14;
                        }
                        int n4 = DPCDDataBlock.convertAddress(by2, by3, by4);
                        object = new DPCDRequestMessage(dPCDMessageType, (DPCDCommandType)enum_, n4, n2);
                        this.aMessage = object;
                        this.aState = 13;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(3, n3, this.aState));
                        continue block14;
                    }
                    if (n2 == 0) {
                        int n5 = DPCDDataBlock.convertAddress(by2, by3, by4);
                        object = new DPCDRequestMessage(dPCDMessageType, (DPCDCommandType)enum_, n5, n2);
                        this.aMessage = object;
                        this.aState = 13;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(3, n3, this.aState));
                        continue block14;
                    }
                    if (n2 > 16) {
                        this.aState = 14;
                        this.aExplanation = "Message Data Length of " + n2 + " exceeds maximum of 16 allowed\n";
                        this.aErrorDataBlock = true;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(3, n3, this.aState));
                        continue block14;
                    }
                    byArray = new byte[n2];
                    n = 0;
                    this.aState = 4;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(3, n3, this.aState));
                    continue block14;
                }
                case 4: {
                    byArray[n] = (byte)n3;
                    if (++n < n2) {
                        this.aState = 4;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(4, n3, this.aState));
                        continue block14;
                    }
                    DPCDMessageType dPCDMessageType = (by & 9) == 9 ? DPCDMessageType.READ_REQUEST : DPCDMessageType.WRITE_REQUEST;
                    Object object = (by & 9) == 9 ? DPCDCommandType.READ : DPCDCommandType.WRITE;
                    int n6 = DPCDDataBlock.convertAddress(by2, by3, by4);
                    DPCDRequestMessage dPCDRequestMessage = new DPCDRequestMessage(dPCDMessageType, (DPCDCommandType)((Object)object), n6, byArray);
                    this.aMessage = dPCDRequestMessage;
                    this.aState = 13;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(4, n3, this.aState));
                    continue block14;
                }
                case 6: {
                    n2 = 1;
                    byArray = new byte[n2];
                    byArray[0] = (byte)n3;
                    if (byArray[0] >= this.getLastMessageDataLength()) {
                        this.aState = 14;
                        this.aExplanation = "M-value of " + byArray[0] + " is larger than requested data length value of " + this.getLastMessageDataLength() + "\n";
                        this.aErrorDataBlock = true;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(6, n3, this.aState));
                        continue block14;
                    }
                    DPCDReplyMessage dPCDReplyMessage = new DPCDReplyMessage(DPCDMessageType.REPLY_TO_WRITE_REQUEST, DPCDCommandType.AUX_NACK, byArray);
                    this.aMessage = dPCDReplyMessage;
                    this.aState = 13;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(6, n3, this.aState));
                    continue block14;
                }
                case 5: {
                    byArray[n] = (byte)n3;
                    if (++n < n2) {
                        this.aState = 5;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(5, n3, this.aState));
                        continue block14;
                    }
                    if (n2 == this.getLastMessageDataLength()) {
                        DPCDReplyMessage dPCDReplyMessage = new DPCDReplyMessage(DPCDMessageType.REPLY_TO_READ_REQUEST, DPCDCommandType.AUX_ACK, byArray);
                        this.aMessage = dPCDReplyMessage;
                        this.aState = 13;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(5, n3, this.aState));
                        continue block14;
                    }
                    this.aState = 5;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(5, n3, this.aState));
                    continue block14;
                }
                case 13: {
                    this.aState = 14;
                    this.aExplanation = "Message contains excess garbage data\n";
                    this.aErrorDataBlock = true;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(13, n3, this.aState));
                    continue block14;
                }
                default: {
                    this.aState = 14;
                    this.aErrorDataBlock = true;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(14, n3, this.aState));
                }
            }
        }
        if (this.aState != 14 && this.aState != 13) {
            this.aStateMachineTransitions.append(DPCDDataBlock.getFormattedStateText(this.aState) + "No Data       " + DPCDDataBlock.getFormattedStateText(14) + "\n");
            this.aState = 14;
            this.aExplanation = "Message is Incomplete\n";
            this.aErrorDataBlock = true;
        }
        if (this.aState == 13) {
            DPCDReplyMessage dPCDReplyMessage;
            this.aMessage.setIsNative();
            StringBuffer stringBuffer = new StringBuffer(this.aMessageParsedDetail);
            if (this.aMessage instanceof DPCDRequestMessage) {
                DPCDRequestMessage dPCDRequestMessage = (DPCDRequestMessage)this.aMessage;
                if (dPCDRequestMessage.getMessageType() == DPCDMessageType.WRITE_REQUEST) {
                    stringBuffer.append(DPCDDataBlock.parseWriteRequestContentData(dPCDRequestMessage));
                    this.aMessageParsedDetail = stringBuffer.toString();
                }
            } else if (this.aMessage instanceof DPCDReplyMessage && (dPCDReplyMessage = (DPCDReplyMessage)this.aMessage).getMessageType() == DPCDMessageType.REPLY_TO_READ_REQUEST) {
                stringBuffer.append(DPCDDataBlock.parseReplyContentData(dPCDReplyMessage));
                this.aMessageParsedDetail = stringBuffer.toString();
            }
        }
    }

    private void parseNonNativeRequest(Integer[] integerArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        DPCDCommandType dPCDCommandType = DPCDCommandType.WRITE;
        DPCDMessageType dPCDMessageType = DPCDMessageType.WRITE_REQUEST;
        block8: for (int i = 13; i < integerArray.length && this.aState != 14; ++i) {
            int n4 = integerArray[i];
            switch (this.aState) {
                case 7: {
                    if ((n4 & 0x8F) != 0) {
                        this.aState = 14;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(7, n4, this.aState));
                        StringBuffer stringBuffer = new StringBuffer("");
                        if ((n4 & 0x80) != 0) {
                            stringBuffer.append("This is a native DisplayPort transaction\n");
                        } else {
                            stringBuffer.append("Invalid I2C address\n");
                        }
                        this.aExplanation = stringBuffer.toString();
                        continue block8;
                    }
                    if ((n4 & 0x40) == 64) {
                        bl = true;
                    }
                    sIsMOT = bl;
                    if ((n4 & 0x30) == 0) {
                        dPCDCommandType = DPCDCommandType.WRITE;
                        dPCDMessageType = DPCDMessageType.WRITE_REQUEST;
                    } else if ((n4 & 0x30) == 16) {
                        dPCDCommandType = DPCDCommandType.READ;
                        dPCDMessageType = DPCDMessageType.READ_REQUEST;
                    } else if ((n4 & 0x30) == 32) {
                        dPCDCommandType = DPCDCommandType.UPDATE;
                        dPCDMessageType = DPCDMessageType.STATUS_UPDATE_REQUEST;
                    } else if ((n4 & 0x30) == 48) {
                        this.aState = 14;
                        this.aExplanation = "Invalid Request Command:  48\n";
                        continue block8;
                    }
                    this.aState = 8;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(7, n4, this.aState));
                    continue block8;
                }
                case 8: {
                    if (!bl2) {
                        if (n4 != 0) {
                            this.aState = 14;
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(8, n4, this.aState));
                            this.aExplanation = "Invalid I2C Address\n";
                            continue block8;
                        }
                        bl2 = true;
                        this.aState = 8;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(8, n4, this.aState));
                        continue block8;
                    }
                    if ((n4 & 0x80) == 128) {
                        this.aState = 14;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(8, n4, this.aState));
                        this.aExplanation = "Invalid I2C Address\n";
                        continue block8;
                    }
                    n = n4;
                    if (i == integerArray.length - 1) {
                        this.aState = 13;
                        this.aMessage = new DPCDRequestMessage(dPCDMessageType, dPCDCommandType, n, 0, sIsMOT);
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(8, n4, this.aState));
                        continue block8;
                    }
                    this.aState = 9;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(8, n4, this.aState));
                    continue block8;
                }
                case 9: {
                    n2 = n4 + 1;
                    if (dPCDMessageType == DPCDMessageType.READ_REQUEST) {
                        if (n2 > 16) {
                            this.aState = 14;
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(9, n4, this.aState));
                            this.aExplanation = "Invalid Data Length '" + n2 + "' exceeds maximum of 16\n";
                            continue block8;
                        }
                        this.aMessage = new DPCDRequestMessage(dPCDMessageType, dPCDCommandType, n, n2, sIsMOT);
                        this.aState = 13;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(9, n4, this.aState));
                        continue block8;
                    }
                    if (n2 > 16) {
                        this.aState = 14;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(9, n4, this.aState));
                        this.aExplanation = "Invalid Data Length '" + n2 + "' exceeds maximum of 16\n";
                        continue block8;
                    }
                    byArray = new byte[n2];
                    n3 = 0;
                    this.aState = 10;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(9, n4, this.aState));
                    continue block8;
                }
                case 10: {
                    byArray[n3] = (byte)n4;
                    if (++n3 < n2) {
                        this.aState = 10;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(10, n4, this.aState));
                        continue block8;
                    }
                    this.aMessage = new DPCDRequestMessage(dPCDMessageType, dPCDCommandType, n, byArray, sIsMOT);
                    this.aState = 13;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(10, n4, this.aState));
                    continue block8;
                }
                case 13: {
                    this.aState = 14;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(13, n4, this.aState));
                    this.aExplanation = "Excess invalid bytes at the end of this packet\n";
                    continue block8;
                }
                case 14: {
                    this.aState = 14;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(14, n4, this.aState));
                }
            }
        }
        if (this.aState != 14 && this.aState != 13) {
            this.aStateMachineTransitions.append(DPCDDataBlock.getFormattedStateText(this.aState) + "No Data       " + DPCDDataBlock.getFormattedStateText(14) + "\n");
            this.aState = 14;
            this.aExplanation = "Incomplete Data Packet\n";
        }
        if (this.aState == 14) {
            this.aErrorDataBlock = true;
        }
    }

    private void parseNonNativeReply(Integer[] integerArray) {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        DPCDCommandType dPCDCommandType = DPCDCommandType.UNDEFINED;
        DPCDMessageType dPCDMessageType = DPCDMessageType.UNDEFINED;
        block11: for (int i = 13; i < integerArray.length && this.aState != 14; ++i) {
            int n3 = integerArray[i];
            switch (this.aState) {
                case 11: {
                    if ((n3 & 0x3F) != 0) {
                        this.aState = 14;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(11, n3, this.aState));
                        if ((n3 & 0x30) != 0) {
                            this.aExplanation = "Invalid Reply Command Byte - Specifies a Native DisplayPort Transaction\n";
                            continue block11;
                        }
                        this.aExplanation = "Invalid Reply Command Byte - Corrupted Content\n";
                        continue block11;
                    }
                    DPCDMessageType dPCDMessageType2 = this.getLastMessageType();
                    switch (dPCDMessageType2) {
                        case READ_REQUEST: {
                            dPCDMessageType = DPCDMessageType.REPLY_TO_READ_REQUEST;
                            break;
                        }
                        case WRITE_REQUEST: {
                            dPCDMessageType = DPCDMessageType.REPLY_TO_WRITE_REQUEST;
                            break;
                        }
                        case STATUS_UPDATE_REQUEST: {
                            dPCDMessageType = DPCDMessageType.REPLY_TO_STATUS_UPDATE_REQUEST;
                            break;
                        }
                        default: {
                            this.aState = 14;
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(11, n3, this.aState));
                            this.aExplanation = "Cannot Reply to a Reply Message\n";
                        }
                    }
                    if ((n3 & 0xC0) == 0) {
                        dPCDCommandType = DPCDCommandType.AUX_ACK;
                        if (i == integerArray.length - 1) {
                            this.aState = 13;
                            this.aMessage = new DPCDReplyMessage(dPCDMessageType, dPCDCommandType, sIsMOT);
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(11, n3, this.aState));
                            continue block11;
                        }
                        n = 0;
                        n2 = integerArray.length - 1 - i;
                        byArray = new byte[n2];
                        this.aState = 12;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(11, n3, this.aState));
                        continue block11;
                    }
                    if ((n3 & 0xC0) == 64) {
                        if (dPCDMessageType != DPCDMessageType.REPLY_TO_WRITE_REQUEST) {
                            this.aState = 14;
                            this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(11, n3, this.aState));
                            this.aExplanation = "Cannot NACK a Previous Read Request Message\n";
                            continue block11;
                        }
                        dPCDCommandType = DPCDCommandType.AUX_NACK;
                        n = 0;
                        n2 = 1;
                        byArray = new byte[n2];
                        this.aState = 12;
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(11, n3, this.aState));
                        continue block11;
                    }
                    if ((n3 & 0xC0) == 128) {
                        dPCDCommandType = DPCDCommandType.AUX_DEFER;
                        this.aState = 13;
                        this.aMessage = new DPCDReplyMessage(dPCDMessageType, dPCDCommandType, sIsMOT);
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(11, n3, this.aState));
                        continue block11;
                    }
                    if ((n3 & 0xC0) != 192) continue block11;
                    this.aState = 14;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(11, n3, this.aState));
                    this.aExplanation = "I2C_RESERVED is an Invalid Reply Command Type\n";
                    continue block11;
                }
                case 12: {
                    byArray[n] = (byte)n3;
                    if (++n == n2) {
                        this.aState = 13;
                        this.aMessage = new DPCDReplyMessage(dPCDMessageType, dPCDCommandType, byArray, sIsMOT);
                        this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(12, n3, this.aState));
                        continue block11;
                    }
                    this.aState = 12;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(12, n3, this.aState));
                    continue block11;
                }
                case 13: {
                    this.aState = 14;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(13, n3, this.aState));
                    this.aExplanation = "Excess invalid bytes at the end of this packet\n";
                    continue block11;
                }
                case 14: {
                    this.aState = 14;
                    this.aStateMachineTransitions.append(DPCDDataBlock.makeDisplayString(14, n3, this.aState));
                }
            }
        }
        if (this.aState != 14 && this.aState != 13) {
            this.aStateMachineTransitions.append(DPCDDataBlock.getFormattedStateText(this.aState) + "No Data       " + DPCDDataBlock.getFormattedStateText(14) + "\n");
            this.aState = 14;
            this.aExplanation = "Incomplete Data Packet\n";
        }
        if (this.aState == 14) {
            this.aErrorDataBlock = true;
        }
    }

    public static void resetParser() {
        sLastBlock = null;
    }

    private DPCDMessageType getLastMessageType() {
        DPCDMessage dPCDMessage;
        DPCDMessageType dPCDMessageType = DPCDMessageType.UNDEFINED;
        if (sLastBlock != null && (dPCDMessage = DPCDDataBlock.sLastBlock.aMessage) != null) {
            dPCDMessageType = dPCDMessage.getMessageType();
        }
        return dPCDMessageType;
    }

    public boolean isNative() {
        return this.aNative;
    }

    private static boolean wasLastBlockNative() {
        boolean bl = false;
        if (sLastBlock != null) {
            bl = sLastBlock.isNative();
        }
        return bl;
    }

    private int getLastMessageDataLength() {
        DPCDMessage dPCDMessage;
        int n = 0;
        if (sLastBlock != null && (dPCDMessage = DPCDDataBlock.sLastBlock.aMessage) != null && dPCDMessage instanceof DPCDRequestMessage) {
            DPCDRequestMessage dPCDRequestMessage = (DPCDRequestMessage)dPCDMessage;
            n = dPCDRequestMessage.getDataLength();
        }
        return n;
    }

    public Integer[] getRawMessage() {
        return this.aRawPacket;
    }

    public int getSourceID() {
        return this.aSourceID;
    }

    public long getTimestamp() {
        return this.aTimestamp;
    }

    private static int convertAddress(byte by, byte by2, byte by3) {
        int n = 0;
        n |= (by & 0xF) << 16;
        n |= (by2 & 0xFF) << 8;
        return n |= by3 & 0xFF;
    }

    public static String getDataValueAsHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        String string2 = string.length() == 1 ? "0x0" : "0x";
        String string3 = string2 + string;
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n2 = 14 - string3.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static int getMaximumStateDescriptionLength() {
        int n = 0;
        for (int i = 1; i <= 14; ++i) {
            String string = DPCDDataBlock.getStateText(i);
            if (string.length() <= n) continue;
            n = string.length();
        }
        return n;
    }

    public static String getFormattedStateText(int n) {
        StringBuffer stringBuffer = new StringBuffer("" + DPCDDataBlock.getStateText(n));
        int n2 = DPCDDataBlock.getMaximumStateDescriptionLength() - stringBuffer.length() + PADDING;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String getStateText(int n) {
        String string = "UNDEFINED";
        switch (n) {
            case 1: 
            case 7: 
            case 11: {
                string = "GET_COMMAND";
                break;
            }
            case 2: 
            case 8: {
                string = "READ_REQUEST_ADDRESS";
                break;
            }
            case 3: 
            case 9: {
                string = "READ_REQUEST_DATA_LENGTH";
                break;
            }
            case 4: 
            case 10: {
                string = "READ_REQUEST_DATA_BYTES";
                break;
            }
            case 5: 
            case 12: {
                string = "READ_REPLY_DATA_BYTES";
                break;
            }
            case 6: {
                string = "READ_REPLY_DATA_BYTE_M";
                break;
            }
            case 13: {
                string = "DONE";
                break;
            }
            case 14: {
                string = "ERROR";
                break;
            }
        }
        return string;
    }

    private static int lastBlockAddress() {
        DPCDMessage dPCDMessage;
        int n = -1;
        if (sLastBlock != null && (dPCDMessage = DPCDDataBlock.sLastBlock.aMessage) != null && dPCDMessage instanceof DPCDRequestMessage) {
            DPCDRequestMessage dPCDRequestMessage = (DPCDRequestMessage)dPCDMessage;
            n = dPCDRequestMessage.getAddress();
        }
        return n;
    }

    private static String getContentData(int n, byte by) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                stringBuffer.append("DPCD_REV:\n");
                if ((by & 0x30) == 32) {
                    stringBuffer.append("    Major Revision Number 1.0\n");
                } else if ((by & 0x30) == 48) {
                    stringBuffer.append("    Major Revision Number 1.1\n");
                } else {
                    stringBuffer.append("    Major Revision Number Undefined Value - Data '" + DPCDDataBlock.longAddressToHexString(by & 0x30) + "'\n");
                }
                if ((by & 3) == 2) {
                    stringBuffer.append("    Minor Revision Number 1.0\n");
                    break;
                }
                if ((by & 3) == 3) {
                    stringBuffer.append("    Minor Revision Number 1.1\n");
                    break;
                }
                stringBuffer.append("    Minor Revision Number Undefined Value - Data '" + DPCDDataBlock.longAddressToHexString(by & 3) + "'\n");
                break;
            }
            case 1: 
            case 256: 
            case 537: {
                if (n == 1) {
                    stringBuffer.append("MAX_LINK_RATE:  ");
                } else if (n == 256) {
                    stringBuffer.append("LINK_BW_SET:  ");
                } else {
                    stringBuffer.append("TEST_LINK_RATE:  ");
                }
                if (by == 6) {
                    stringBuffer.append("1.62Gbps");
                } else if (by == 10) {
                    stringBuffer.append("2.7Gbps");
                } else {
                    stringBuffer.append("Undefined Value - Data '" + by + "'");
                }
                if (n != 537 && (by == 6 || by == 10)) {
                    stringBuffer.append(" per lane");
                }
                stringBuffer.append("\n");
                break;
            }
            case 2: 
            case 257: 
            case 544: {
                if (n == 2) {
                    stringBuffer.append("MAXIMUM_LANE_COUNT:  ");
                } else if (n == 257) {
                    stringBuffer.append("LANE_COUNT_SET:  ");
                } else {
                    stringBuffer.append("TEST_LANE_COUNT:  ");
                }
                if ((by & 0xF) == 1) {
                    stringBuffer.append("One Lane (Lane0)\n");
                } else if ((by & 0xF) == 2) {
                    stringBuffer.append("Two Lanes (Lane0, Lane1)\n");
                } else if ((by & 0xF) == 4) {
                    stringBuffer.append("Four Lanes (Lane0, Lane1, Lane2, Lane3)\n");
                } else {
                    stringBuffer.append("Undefined Value - Data '" + by + "'\n");
                }
                if (n == 544) break;
                if ((by & 0x80) == 128) {
                    stringBuffer.append("    ENHANCED_FRAME_CAP:  Enhanced Framing Symbol Sequence is Supported\n");
                    break;
                }
                stringBuffer.append("    ENHANCED_FRAME_CAP:  Enhanced Framing Symbol Sequence is NOT Supported\n");
                break;
            }
            case 3: {
                stringBuffer.append("MAX_DOWNSPREAD:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    MAX_DOWNSPREAD:  0.5% down spread\n");
                } else {
                    stringBuffer.append("    MAX_DOWNSPREAD:  No down spread\n");
                }
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    NO_AUX_HANDSHAKE_LINK_TRAINING:  An AUX Handshake Required to Synchronize DisplayPort Transmitter\n");
                    break;
                }
                stringBuffer.append("    NO_AUX_HANDSHAKE_LINK_TRAINING:  No AUX Handshake Required\n");
                break;
            }
            case 4: {
                if ((by & 1) == 1) {
                    stringBuffer.append("NORP:  Set\n");
                    break;
                }
                stringBuffer.append("NORP:  NOT set\n");
                break;
            }
            case 5: {
                if ((by & 1) == 1) {
                    stringBuffer.append("DWN_STRM_PORT_PRESENT:  This Device Has a Downstream Port\n");
                    if ((by & 6) == 6) {
                        stringBuffer.append("    DWN_STRM_PORT_TYPE:  Other\n");
                    } else if ((by & 6) == 4) {
                        stringBuffer.append("    DWN_STRM_PORT_TYPE:  Analog VGA or Analog Video over DVI-I\n");
                    } else if ((by & 6) == 2) {
                        stringBuffer.append("    DWN_STRM_PORT_TYPE:  DVI or HDMI\n");
                    } else {
                        stringBuffer.append("    DWN_STRM_PORT_TYPE:  DisplayPort\n");
                    }
                    if ((by & 8) == 8) {
                        stringBuffer.append("    FORMAT_CONVERSION:  This downstream port has a format conversion block\n");
                        break;
                    }
                    stringBuffer.append("    FORMAT_CONVERSION:  This Branch Device does not have a format conversion block\n");
                    break;
                }
                stringBuffer.append("DWN_STRM_PORT_PRESENT:  This Device Has No Downstream Port\n");
                break;
            }
            case 6: {
                if ((by & 1) == 1) {
                    stringBuffer.append("MAIN_LINK_CHANNEL_CODING:  DisplayPort Receiver Supports Main Link Channel Coding\n");
                    break;
                }
                stringBuffer.append("MAIN_LINK_CHANNEL_CODING:  DisplayPort Receiver Does NOT Support Main Link Channel Coding\n");
                break;
            }
            case 7: {
                stringBuffer.append("DOWNSTREAM_PORT_COUNT:\n");
                int n4 = by & 0xF;
                stringBuffer.append("    DWN_STRM_PORT_COUNT:  '" + n4 + "'\n");
                if ((by & 0x80) == 128) {
                    stringBuffer.append("    OUI:  Supported\n");
                    break;
                }
                stringBuffer.append("    OUI:  NOT Supported\n");
                break;
            }
            case 8: 
            case 10: {
                if (n == 8) {
                    stringBuffer.append("RECEIVE_PORT0_CAP_0:  '" + by + "'\n");
                } else {
                    stringBuffer.append("RECEIVE_PORT1_CAP_0:  '" + by + "'\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    LOCAL_EDID_PRESENT:  This receiver port has a local EDID\n");
                } else {
                    stringBuffer.append("    LOCAL_EDID_PRESENT:  This receiver port does not have a local EDID\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    ASSOCIATED_TO_PRECEDING_PORT:  This port is used for secondary isochronous stream\n");
                    break;
                }
                stringBuffer.append("    ASSOCIATED_TO_PRECEDING_PORT:  This port is used for main isochronous stream\n");
                break;
            }
            case 9: 
            case 11: {
                int n5 = by & 0xFF;
                if (n == 9) {
                    stringBuffer.append("RECEIVE_PORT0_CAP_1:  '" + by + "'\n");
                } else {
                    stringBuffer.append("RECEIVE_PORT1_CAP_1:  '" + by + "'\n");
                }
                int n6 = (n5 + 1) * 32;
                stringBuffer.append("    Buffer Size:  '" + n6 + "'\n");
                break;
            }
            case 258: {
                stringBuffer.append("TRAINING_PATTERN_SET:\n");
                if ((by & 3) == 0) {
                    stringBuffer.append("    TRAINING_PATTERN_SET:  Training not in progress (or disabled)\n");
                } else if ((by & 3) == 1) {
                    stringBuffer.append("    TRAINING_PATTERN_SET:  Training Pattern 1\n");
                } else if ((by & 3) == 2) {
                    stringBuffer.append("    TRAINING_PATTERN_SET:  Training Pattern 2\n");
                } else {
                    stringBuffer.append("    TRAINING_PATTERN_SET:  RESERVED\n");
                }
                if ((by & 0xC) == 0) {
                    stringBuffer.append("    LINK_QUAL_PATTERN_SET:  Link Quality Test Pattern Not Transmitted\n");
                } else if ((by & 0xC) == 4) {
                    stringBuffer.append("    LINK_QUAL_PATTERN_SET:  D10.2 Test Pattern (unscrambled) Transmitted\n");
                } else if ((by & 0xC) == 8) {
                    stringBuffer.append("    LINK_QUAL_PATTERN_SET:  Symbol Error Rate Measurement Pattern Transmitted\n");
                } else {
                    stringBuffer.append("    LINK_QUAL_PATTERN_SET:  PRBS7 Transmitted\n");
                }
                if ((by & 0x10) == 16) {
                    stringBuffer.append("    RECOVERED_CLOCK_OUT_EN:  Enabled\n");
                } else {
                    stringBuffer.append("    RECOVERED_CLOCK_OUT_EN:  Not Enabled\n");
                }
                if ((by & 0x20) == 32) {
                    stringBuffer.append("    SCRAMBLING_DISABLE:  Scrambler Disabled\n");
                } else {
                    stringBuffer.append("    SCRAMBLING_DISABLE:  Data Scrambled Before Transmission\n");
                }
                if ((by & 0xC0) == 0) {
                    stringBuffer.append("    SYMBOL_ERROR_COUNT_SEL:  Disparity Error and Illegal Symbol Error\n");
                    break;
                }
                if ((by & 0xC0) == 64) {
                    stringBuffer.append("    SYMBOL_ERROR_COUNT_SEL:  Disparity Error\n");
                    break;
                }
                if ((by & 0xC0) == 128) {
                    stringBuffer.append("    SYMBOL_ERROR_COUNT_SEL:  Illegal Symbol Error\n");
                    break;
                }
                stringBuffer.append("    SYMBOL_ERROR_COUNT_SEL:  Reserved");
                break;
            }
            case 259: 
            case 260: 
            case 261: 
            case 262: {
                int n7 = n - 259;
                int n8 = by & 3;
                stringBuffer.append("TRAINING_LANE" + n7 + "_SET\n");
                stringBuffer.append("    VOLTAGE_SWING_SET:  Training Pattern 1 With Voltage Swing Level " + n8 + "\n");
                if ((by & 4) == 4) {
                    stringBuffer.append("    MAX_SWING_REACHED:  Maximum Driven Current Setting Is Reached\n");
                } else {
                    stringBuffer.append("    MAX_SWING_REACHED:  Maximum Driven Current Setting Is NOT Reached\n");
                }
                int n9 = (by & 0x18) / 8;
                if (n9 == 0) {
                    stringBuffer.append("    PRE-EMPHASIS_SET:  Training Pattern 2 without pre-emphasis\n");
                } else {
                    stringBuffer.append("    PRE-EMPHASIS_SET:  Training Pattern 2 with pre-emphasis level " + n9 + "\n");
                }
                if ((by & 0x20) == 32) {
                    stringBuffer.append("    MAX_PRE-EMPHASIS_REACHED:  Maximum Drive Current Setting Is Reached\n");
                    break;
                }
                stringBuffer.append("    MAX_PRE-EMPHASIS_REACHED:  Maximum Drive Current Setting Is NOT Reached\n");
                break;
            }
            case 263: {
                stringBuffer.append("DOWNSPREAD_CTRL:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    MODULATION_FREQ:  33 kHz\n");
                } else {
                    stringBuffer.append("    MODULATION_FREQ:  30 kHz\n");
                }
                if ((by & 0x10) == 16) {
                    stringBuffer.append("    SPREAD_AMP:  0.5% down spread\n");
                    break;
                }
                stringBuffer.append("    SPREAD_AMP:  0.0% down spread\n");
                break;
            }
            case 264: {
                if ((by & 1) == 1) {
                    stringBuffer.append("MAIN_LINK_CHANNEL_CODING_SET:  SET_ANSI 8B10B\n");
                    break;
                }
                stringBuffer.append("MAIN_LINK_CHANNEL_CODING_SET:  Not Selected\n");
                break;
            }
            case 512: {
                stringBuffer.append("SINK_COUNT:\n");
                int n10 = by & 0x3F;
                stringBuffer.append("    SINK_COUNT:  " + n10 + "\n");
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    CP_READY:  All Sink Devices Are CP-Capable\n");
                    break;
                }
                stringBuffer.append("    CP_READY:  At Least One Sink Device Is NOT CP-Capable\n");
                break;
            }
            case 513: {
                stringBuffer.append("DEVICE_SERVICE_IRQ_VECTOR:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    REMOTE_CONTROL_COMMAND_PENDING:  Command Is Pending\n");
                } else {
                    stringBuffer.append("    REMOTE_CONTROL_COMMAND_PENDING:  No Command Pending\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    AUTOMATED_TEST_REQUEST:  Must Read Addresses 00218h-0027Fh for Requested Link Test\n");
                } else {
                    stringBuffer.append("    AUTOMATED_TEST_REQUEST:  No Automated Test Request Pending\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    CP_IRQ:  Set\n");
                } else {
                    stringBuffer.append("    CP_IRQ:  Not Set\n");
                }
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    SINK_SPECIFIC_IRQ:  Set\n");
                    break;
                }
                stringBuffer.append("    SINK_SPECIFIC_IRQ:  Not Set\n");
                break;
            }
            case 514: 
            case 515: {
                n2 = 0;
                n3 = 1;
                if (n == 515) {
                    n2 = 2;
                    n3 = 3;
                }
                stringBuffer.append("LANE" + n2 + "_" + n3 + "_STATUS:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    LANE" + n2 + "_CR_DONE:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n2 + "_CR_DONE:  Cleared\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    LANE" + n2 + "_CHANNEL_EQ_DONE:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n2 + "_CHANNEL_EQ_DONE:  Cleared\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    LANE" + n2 + "_SYMBOL_LOCKED:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n2 + "_SYMBOL_LOCKED:  Cleared\n");
                }
                if ((by & 0x10) == 16) {
                    stringBuffer.append("    LANE" + n3 + "_CR_DONE:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n3 + "_CR_DONE:  Cleared\n");
                }
                if ((by & 0x20) == 32) {
                    stringBuffer.append("    LANE" + n3 + "_CHANNEL_EQ_DONE:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n3 + "_CHANNEL_EQ_DONE:  Cleared\n");
                }
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    LANE" + n3 + "_SYMBOL_LOCKED:  Set\n");
                    break;
                }
                stringBuffer.append("    LANE" + n3 + "_SYMBOL_LOCKED:  Cleared\n");
                break;
            }
            case 516: {
                stringBuffer.append("LANE_ALIGN__STATUS_UPDATED:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    INTERLANE_ALIGN_DONE:  Set\n");
                } else {
                    stringBuffer.append("    INTERLANE_ALIGN_DONE:  Cleared\n");
                }
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    DOWNSTREAM_PORT_STATUS_CHANGED:  Set\n");
                } else {
                    stringBuffer.append("    DOWNSTREAM_PORT_STATUS_CHANGED:  Cleared\n");
                }
                if ((by & 0x80) == 128) {
                    stringBuffer.append("    LINK_STATUS_UPDATED:  Set\n");
                    break;
                }
                stringBuffer.append("    LINK_STATUS_UPDATED:  Cleared\n");
                break;
            }
            case 517: {
                stringBuffer.append("SINK_STATUS:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    RECEIVE_PORT_0_STATUS:  Sink in synchronization\n");
                } else {
                    stringBuffer.append("    RECEIVE_PORT_0_STATUS:  Sink out of synchronization\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    RECEIVE_PORT_1_STATUS:  Sink in synchronization\n");
                    break;
                }
                stringBuffer.append("    RECEIVE_PORT_1_STATUS:  Sink out of synchronization\n");
                break;
            }
            case 518: 
            case 519: {
                n2 = 0;
                n3 = 1;
                if (n == 519) {
                    n2 = 2;
                    n3 = 3;
                }
                stringBuffer.append("ADJUST_REQUEST_LANE" + n2 + "_" + n3 + ":\n");
                int n11 = by & 3;
                int n12 = (by & 0xC) / 4;
                stringBuffer.append("    VOLTAGE_SWING_LANE_" + n2 + ":  " + n11 + "\n");
                stringBuffer.append("    PRE-EMPHASIS_LANE_" + n2 + ":  " + n12 + "\n");
                n11 = (by & 0x30) / 16;
                n12 = (by & 0xC0) / 64;
                stringBuffer.append("    VOLTAGE_SWING_LANE_" + n3 + ":  " + n11 + "\n");
                stringBuffer.append("    PRE-EMPHASIS_LANE_" + n3 + ":  " + n12 + "\n");
                break;
            }
            case 528: 
            case 529: 
            case 530: 
            case 531: 
            case 532: 
            case 533: 
            case 534: 
            case 535: {
                int n13 = 0;
                if (n == 530 || n == 531) {
                    n13 = 1;
                } else if (n == 532 || n == 533) {
                    n13 = 2;
                } else if (n == 534 || n == 535) {
                    n13 = 3;
                }
                stringBuffer.append("SYMBOL_ERROR_COUNT_LANE" + n13 + "\n");
                if (n % 2 == 0) {
                    stringBuffer.append("    ERROR_COUNT_BITS7-0:  " + by + "\n");
                    break;
                }
                stringBuffer.append("    ERROR_COUNT_BITS14-8:  " + by + "\n");
                if ((by & 0x80) == 128) {
                    stringBuffer.append("    ERROR_COUNT_VALID:  Set\n");
                    break;
                }
                stringBuffer.append("    ERROR_COUNT_VALID:  Cleared\n");
                break;
            }
            case 536: {
                stringBuffer.append("TEST_REQUEST:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    TEST_LINK_TRAINING:  Link Training Test Requested\n");
                } else {
                    stringBuffer.append("    TEST_LINK_TRAINING:  No Link Training Test Requested\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    TEST_PATTERN:  Test Pattern Requested\n");
                } else {
                    stringBuffer.append("    TEST_PATTERN:  No Test Pattern Requested\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    TEST_EDID_READ:  EDID Read Test Requested\n");
                } else {
                    stringBuffer.append("    TEST_EDID_READ:  No EDID Read Test Requested\n");
                }
                if ((by & 8) == 8) {
                    stringBuffer.append("    PHY_TEST_PATTERN:  PHY Test Pattern Requested\n");
                    break;
                }
                stringBuffer.append("    PHY_TEST_PATTERN:  No Request for PHY Test Pattern\n");
                break;
            }
            case 545: {
                stringBuffer.append("TEST_PATTERN:  " + by + " - ");
                if (by == 1) {
                    stringBuffer.append("color ramps\n");
                    break;
                }
                if (by == 2) {
                    stringBuffer.append("black and white vertical lines\n");
                    break;
                }
                if (by == 3) {
                    stringBuffer.append("color square\n");
                    break;
                }
                stringBuffer.append("Undefined Value\n");
                break;
            }
            case 546: 
            case 547: 
            case 548: 
            case 549: {
                if (n == 546 || n == 547) {
                    stringBuffer.append("TEST_H_TOTAL:  ");
                } else {
                    stringBuffer.append("TEST_V_TOTAL:  ");
                }
                if (n % 2 == 0) {
                    stringBuffer.append("Bits 15-8:  " + by + "\n");
                    break;
                }
                stringBuffer.append("Bits 7-0:  " + by + "\n");
                break;
            }
            case 550: 
            case 551: 
            case 552: 
            case 553: {
                if (n == 550 || n == 551) {
                    stringBuffer.append("TEST_H_START:  ");
                } else {
                    stringBuffer.append("TEST_V_START:  ");
                }
                if (n % 2 == 0) {
                    stringBuffer.append("Bits 15-8:  " + by + "\n");
                    break;
                }
                stringBuffer.append("Bits 7-0:  " + by + "\n");
                break;
            }
            case 554: 
            case 555: 
            case 556: 
            case 557: {
                String string = "H";
                if (n == 556 || n == 557) {
                    string = "V";
                }
                stringBuffer.append("TEST_" + string + "SYNC:\n");
                if (n % 2 == 0) {
                    if ((by & 0x80) == 128) {
                        stringBuffer.append("    TEST_" + string + "SYNC_POLARITY:  Set\n");
                    } else {
                        stringBuffer.append("    TEST_" + string + "SYNC_POLARITY:  Cleared\n");
                    }
                    int n14 = by & 0x7F;
                    stringBuffer.append("    TEST_" + string + "SYNC_WIDTH Bits 14-8:  " + n14 + "\n");
                    break;
                }
                int n15 = by & 0xFF;
                stringBuffer.append("    TEST_" + string + "SYNC_WIDTH Bits 7-0:  " + n15 + "\n");
                break;
            }
            case 558: 
            case 559: 
            case 560: 
            case 561: {
                String string = "H_WIDTH";
                if (n == 560 || n == 561) {
                    string = "V_HEIGHT";
                }
                stringBuffer.append("TEST_" + string + ":\n");
                if (n % 2 == 0) {
                    stringBuffer.append("    TEST_" + string + " Bits 15-8:  " + by + "\n");
                    break;
                }
                stringBuffer.append("    TEST_" + string + " Bits 7-0:  " + by + "\n");
                break;
            }
            case 562: {
                stringBuffer.append("TEST_MISC:\n");
                String string = "S";
                if ((by & 1) == 0) {
                    string = "As";
                }
                stringBuffer.append("    TEST_SYNCHRONOUS_CLOCK:  Link Clock and Stream Clock " + string + "\n");
                if ((by & 6) == 0) {
                    stringBuffer.append("    TEST_COLOR_FORMAT:  RGB\n");
                } else if ((by & 6) == 2) {
                    stringBuffer.append("    TEST_COLOR_FORMAT:  YCbCr 4:2:2\n");
                } else if ((by & 6) == 4) {
                    stringBuffer.append("    TEST_COLOR_FORMAT:  YCbCr 4:4:4\n");
                } else {
                    stringBuffer.append("    TEST_COLOR_FORMAT:  Reserved\n");
                }
                String string2 = "VESA range (from 0 to maximum)";
                if ((by & 8) == 8) {
                    string2 = "CEA range (as defined in CEA-861C Section 5)";
                }
                stringBuffer.append("    TEST_DYNAMIC_RANGE:  " + string2 + "\n");
                String string3 = "ITU601";
                if ((by & 0x10) == 16) {
                    string3 = "ITU709";
                }
                stringBuffer.append("    TEST_YCBCR_COEFFICIENTS:  " + string3 + "\n");
                int n16 = (by & 0xE0) / 64;
                int n17 = 6 + n16 * 2;
                if (n16 == 4) {
                    n17 += 2;
                }
                if (n16 >= 5) {
                    stringBuffer.append("    TEST_BIT_DEPTH:  Reserved\n");
                } else {
                    stringBuffer.append("    TEST_BIT_DEPTH:  " + n17 + " bits\n");
                }
                stringBuffer.append("    TEST_BIT_DEPTH:  \n");
                break;
            }
            case 563: {
                stringBuffer.append("TEST_MISC:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    TEST_REFRESH_DENOMINATOR:  1.001\n");
                } else {
                    stringBuffer.append("    TEST_REFRESH_DENOMINATOR:  1\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    TEST_INTERLACED:  Interlaced\n");
                    break;
                }
                stringBuffer.append("    TEST_INTERLACED:  Non-Interlaced\n");
                break;
            }
            case 564: {
                stringBuffer.append("TEST_REFRESH_RATE_NUMERATOR:  " + by + "\n");
                stringBuffer.append("    Refresh Rate = TEST_REFRESH_RATE_NUMERATOR / TEST_REFRESH_RATE_DENOMINATOR\n");
                break;
            }
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: {
                String string = "R_Cr";
                if (n == 578 || n == 579) {
                    string = "G_Y";
                } else if (n == 580 || n == 581) {
                    string = "B_Cb";
                }
                stringBuffer.append("TEST_CRC_" + string + ":\n");
                if (n % 2 == 0) {
                    stringBuffer.append("    CRC Value Bits 7-0:  " + by + "\n");
                    break;
                }
                stringBuffer.append("    CRC Value Bits 15-8:  " + by + "\n");
                break;
            }
            case 582: {
                stringBuffer.append("TEST_SYNC_MISC:\n");
                int n18 = by & 0xF;
                stringBuffer.append("    TEST_CRC_COUNT:  " + n18 + "\n");
                if ((by & 0x20) == 32) {
                    stringBuffer.append("    TEST_CRC_SUPPORTED:  CRC Supported By Sink Device\n");
                    break;
                }
                stringBuffer.append("    TEST_CRC_SUPPORTED:  CRC NOT Supported By Sink Device\n");
                break;
            }
            case 584: {
                stringBuffer.append("PHY_TEST_PATTERN:\n");
                if ((by & 3) == 0) {
                    stringBuffer.append("    PHY_TEST_PATTERN_SEL:  No Test Pattern Selected\n");
                    break;
                }
                if ((by & 3) == 1) {
                    stringBuffer.append("    PHY_TEST_PATTERN_SEL:  D10.2 Without Scrambling\n");
                    break;
                }
                if ((by & 3) == 2) {
                    stringBuffer.append("    PHY_TEST_PATTERN_SEL:  Symbol Error Measurement Count\n");
                    break;
                }
                stringBuffer.append("    PHY_TEST_PATTERN_SEL:  PRBS7\n");
                break;
            }
            case 608: {
                stringBuffer.append("TEST_RESPONSE:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    TEST_ACK:  Positive ACK of TEST_REQ\n");
                } else {
                    stringBuffer.append("    TEST_ACK:  Writing 0 has no effect on TEST_REQ state\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    TEST_NAK:  Negative ACK of TEST_REQ\n");
                } else {
                    stringBuffer.append("    TEST_NAK:  Writing 0 has no effect on TEST_REQ state\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    TEST_EDID_CHECKSUM_WRITE:  EDID Checksum has been Written to TEST_EDID_CHECKSUM\n");
                    break;
                }
                stringBuffer.append("    TEST_EDID_CHECKSUM_WRITE:  No Write to TEST_EDID_CHECKSUM\n");
                break;
            }
            case 609: {
                stringBuffer.append("TEST_EDID_CHECKSUM:  " + by + "\n");
                break;
            }
            case 624: {
                stringBuffer.append("TEST_SINK:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    TEST_SINK_START:  Start Calculating CRC on the Next Frame\n");
                    break;
                }
                stringBuffer.append("    TEST_SINK_START:  Stop Calculating CRC on the Next Frame\n");
                break;
            }
            case 768: {
                stringBuffer.append("SOURCE_IEEE_OUI 7-0:  " + by + "\n");
                break;
            }
            case 769: {
                stringBuffer.append("SOURCE_IEEE_OUI 15-8:  " + by + "\n");
                break;
            }
            case 770: {
                stringBuffer.append("SOURCE_IEEE_OUI 23-16:  " + by + "\n");
                break;
            }
            case 1024: {
                stringBuffer.append("SINK_IEEE_OUI 7-0:  " + by + "\n");
                break;
            }
            case 1025: {
                stringBuffer.append("SINK_IEEE_OUI 15-8:  " + by + "\n");
                break;
            }
            case 1026: {
                stringBuffer.append("SINK_IEEE_OUI 23-16:  " + by + "\n");
                break;
            }
            case 1280: {
                stringBuffer.append("BRANCH_IEEE_OUI 7-0:  " + by + "\n");
                break;
            }
            case 1281: {
                stringBuffer.append("BRANCH_IEEE_OUI 15-8:  " + by + "\n");
                break;
            }
            case 1282: {
                stringBuffer.append("BRANCH_IEEE_OUI 23-16:  " + by + "\n");
                break;
            }
            case 1536: {
                stringBuffer.append("SET_POWER:\n");
                if ((by & 3) == 1) {
                    stringBuffer.append("    SET_POWER_STATE:  Set Local Sink and all downstream sinks to D0 (normal operation mode)\n");
                    break;
                }
                if ((by & 3) == 2) {
                    stringBuffer.append("    SET_POWER_STATE:  Set Local Sink and all downstream sinks to D3 (power down mode)\n");
                    break;
                }
                stringBuffer.append("    SET_POWER_STATE:  RESERVED\n");
            }
        }
        return stringBuffer.toString();
    }

    private static int computeKSVFifoOffset(int n) {
        return (n - 426028) % 5;
    }

    private static int computeKSVFifoDeviceNumber(int n) {
        return (n - 426028) / 5 + 1;
    }

    private static String getHDCPData(int n, byte by) {
        StringBuffer stringBuffer = new StringBuffer("");
        switch (n) {
            case 425984: 
            case 425985: 
            case 425986: 
            case 425987: 
            case 425988: {
                stringBuffer.append("Address: " + DPCDDataBlock.longAddressToHexString(n) + "\n");
                stringBuffer.append("Bksv Byte #" + (n - 425984 + 1));
                stringBuffer.append(": " + DPCDDataBlock.longAddressToHexString(by) + "\n");
                break;
            }
            case 425989: 
            case 425990: {
                int n2 = 0;
                if (n == 425989) {
                    sR0 = 0;
                } else {
                    n2 = 8;
                }
                stringBuffer.append("R0' Address " + DPCDDataBlock.longAddressToHexString(n) + ":  Value = " + DPCDDataBlock.longAddressToHexString(sR0 |= by << n2) + "\n");
                break;
            }
            case 425991: 
            case 425992: 
            case 425993: 
            case 425994: 
            case 425995: {
                stringBuffer.append("Address: " + DPCDDataBlock.longAddressToHexString(n) + "\n");
                stringBuffer.append("Aksv Byte #" + (n - 425991 + 1));
                stringBuffer.append(": " + DPCDDataBlock.longAddressToHexString(by) + "\n");
                break;
            }
            case 425996: 
            case 425997: 
            case 425998: 
            case 425999: 
            case 426000: 
            case 426001: 
            case 426002: 
            case 426003: {
                int n3 = 8 * (n - 425996);
                stringBuffer.append("An:\n");
                stringBuffer.append("    SESSION_RANDOM_NUMBER Bits " + (n3 + 7) + "-" + n3 + ":  " + DPCDDataBlock.longAddressToHexString(by) + "\n");
                break;
            }
            case 426004: 
            case 426005: 
            case 426006: 
            case 426007: 
            case 426008: 
            case 426009: 
            case 426010: 
            case 426011: 
            case 426012: 
            case 426013: 
            case 426014: 
            case 426015: 
            case 426016: 
            case 426017: 
            case 426018: 
            case 426019: 
            case 426020: 
            case 426021: 
            case 426022: 
            case 426023: {
                int n4 = (n - 426004) / 4;
                int n5 = 8 * (n % 4);
                if (n5 == 0) {
                    DPCDDataBlock.sVH[n4] = 0;
                }
                int n6 = n4;
                sVH[n6] = sVH[n6] | by << n5;
                stringBuffer.append("V'.H" + n4 + " Address " + DPCDDataBlock.longAddressToHexString(n) + ":  Value = " + DPCDDataBlock.longAddressToHexString(sVH[n4]) + "\n");
                break;
            }
            case 426024: {
                stringBuffer.append("Bcaps:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    HDCP_REPEATER_CAPABILITY:  This HDCP Receiver Supports Downstream Connections\n");
                } else {
                    stringBuffer.append("    HDCP_REPEATER_CAPABILITY:  This HDCP Receiver Does NOT Support Downstream Connections\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    HDCP_CAPABLE:  Yes\n");
                    break;
                }
                stringBuffer.append("    HDCP_CAPABLE:  No\n");
                break;
            }
            case 426025: {
                stringBuffer.append("Bstatus:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    READY:  This HDCP Receiver Built Attached KSV List and Computed Verification Value\n");
                } else {
                    stringBuffer.append("    READY:  KSV List Not Computed or Verified\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    RO'_AVAILABLE:  R0' is Available for Reading at HDCP Receiver\n");
                } else {
                    stringBuffer.append("    RO'_AVAILABLE:  R0' is NOT Available for Reading at HDCP Receiver\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    LINK_INTEGRITY_FAILURE:  Loss of Cipher Synchronization Detected\n");
                    break;
                }
                stringBuffer.append("    LINK_INTEGRITY_FAILURE:  No Loss of Cipher Synchronization Detected\n");
                break;
            }
            case 426026: {
                stringBuffer.append("Binfo:\n");
                int n7 = by & 0x7F;
                boolean bl = (by & 0x80) == 128;
                stringBuffer.append("    DEVICE_COUNT:  " + n7 + "\n");
                stringBuffer.append("    MAX_DEVS_EXCEEDED:  " + bl + "\n");
                break;
            }
            case 426027: {
                stringBuffer.append("Binfo:\n");
                int n8 = by & 7;
                boolean bl = (by & 8) == 8;
                stringBuffer.append("    DEPTH:  " + n8 + " Levels\n");
                stringBuffer.append("    MAX_CASCADE_EXCEEDED:  " + bl + "\n");
                break;
            }
            case 426028: 
            case 426029: 
            case 426030: 
            case 426031: 
            case 426032: 
            case 426033: 
            case 426034: 
            case 426035: 
            case 426036: 
            case 426037: 
            case 426038: 
            case 426039: 
            case 426040: 
            case 426041: 
            case 426042: {
                int n9 = DPCDDataBlock.computeKSVFifoDeviceNumber(n);
                int n10 = DPCDDataBlock.computeKSVFifoOffset(n);
                int n11 = 5 * n9 + n10;
                stringBuffer.append("KSV Fifo Address " + DPCDDataBlock.longAddressToHexString(n) + ":  Value = " + DPCDDataBlock.longAddressToHexString(by) + ", Offset = " + n11 + "\n");
                break;
            }
            case 426176: 
            case 426177: 
            case 426178: 
            case 426179: 
            case 426180: 
            case 426181: 
            case 426182: 
            case 426183: 
            case 426184: 
            case 426185: 
            case 426186: 
            case 426187: 
            case 426188: 
            case 426189: 
            case 426190: 
            case 426191: 
            case 426192: 
            case 426193: 
            case 426194: 
            case 426195: 
            case 426196: 
            case 426197: 
            case 426198: 
            case 426199: 
            case 426200: 
            case 426201: 
            case 426202: 
            case 426203: 
            case 426204: 
            case 426205: 
            case 426206: 
            case 426207: 
            case 426208: 
            case 426209: 
            case 426210: 
            case 426211: 
            case 426212: 
            case 426213: 
            case 426214: 
            case 426215: 
            case 426216: 
            case 426217: 
            case 426218: 
            case 426219: 
            case 426220: 
            case 426221: 
            case 426222: 
            case 426223: 
            case 426224: 
            case 426225: 
            case 426226: 
            case 426227: 
            case 426228: 
            case 426229: 
            case 426230: 
            case 426231: 
            case 426232: 
            case 426233: 
            case 426234: 
            case 426235: 
            case 426236: 
            case 426237: 
            case 426238: 
            case 426239: {
                stringBuffer.append("DEBUG_REGISTER " + DPCDDataBlock.longAddressToHexString(n) + ":  Data Value is '" + DPCDDataBlock.longAddressToHexString(by) + "'\n");
            }
        }
        return stringBuffer.toString();
    }

    private static String longAddressToHexString(int n) {
        String string = String.format("0x%1$X", n);
        return string;
    }

    private static String longAddressToHexString(byte by) {
        String string = String.format("0x%1$02X", by);
        return string;
    }

    private static boolean addressBlockIsReserved(int n) {
        if (n >= 12 && n <= 127) {
            return true;
        }
        if (n >= 144 && n <= 255) {
            return true;
        }
        if (n >= 265 && n <= 511) {
            return true;
        }
        if (n >= 520 && n <= 527) {
            return true;
        }
        if (n >= 565 && n <= 575) {
            return true;
        }
        if (n == 583) {
            return true;
        }
        if (n >= 585 && n <= 607) {
            return true;
        }
        if (n >= 610 && n <= 623) {
            return true;
        }
        if (n >= 625 && n <= 767) {
            return true;
        }
        if (n >= 771 && n <= 1023) {
            return true;
        }
        if (n >= 1027 && n <= 1279) {
            return true;
        }
        if (n >= 1283 && n <= 1535) {
            return true;
        }
        if (n >= 1537 && n <= 1791) {
            return true;
        }
        if (n >= 1792 && n <= 425983) {
            return true;
        }
        if (n >= 430080 && n <= 458751) {
            return true;
        }
        if (n >= 458752 && n <= 524287) {
            return true;
        }
        return n >= 426043 && n <= 426175;
    }

    private static boolean addressIsHDCPBlock(int n) {
        return n >= 425984 && n <= 430079;
    }

    private static String parseWriteRequestContentData(DPCDRequestMessage dPCDRequestMessage) {
        StringBuffer stringBuffer = new StringBuffer("");
        byte[] byArray = dPCDRequestMessage.getData();
        int n = dPCDRequestMessage.getAddress();
        if (DPCDDataBlock.addressBlockIsReserved(n)) {
            stringBuffer.append("DisplayPort Address " + DPCDDataBlock.longAddressToHexString(n) + " is RESERVED\n");
        } else if (DPCDDataBlock.addressIsHDCPBlock(n)) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(DPCDDataBlock.getHDCPData(n, byArray[i]));
                ++n;
            }
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(DPCDDataBlock.getContentData(n, byArray[i]));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private static String parseReplyContentData(DPCDReplyMessage dPCDReplyMessage) {
        StringBuffer stringBuffer = new StringBuffer("");
        byte[] byArray = dPCDReplyMessage.getData();
        int n = DPCDDataBlock.lastBlockAddress();
        if (DPCDDataBlock.addressBlockIsReserved(n)) {
            stringBuffer.append("DisplayPort Address " + DPCDDataBlock.longAddressToHexString(n) + " is RESERVED\n");
        } else if (DPCDDataBlock.addressIsHDCPBlock(n)) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(DPCDDataBlock.getHDCPData(n, byArray[i]));
                ++n;
            }
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(DPCDDataBlock.getContentData(n, byArray[i]));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static void printWithIndent(String string) {
        DPCDDataBlock.printWithIndent(string, 2);
    }

    public static void printWithIndent(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < n; ++i) {
                System.out.print(" ");
            }
            System.out.println(string2);
        }
    }

    public static void printBlock(DPCDDataBlock dPCDDataBlock) {
        DPCDDataBlock.printWithIndent("DPCDDataBlock - Source ID:  '" + dPCDDataBlock.getSourceID() + "'");
        DPCDDataBlock.printWithIndent("DPCDDataBlock - Summary:");
        DPCDDataBlock.printWithIndent(dPCDDataBlock.getSummary(), 4);
        System.out.println("");
        DPCDDataBlock.printWithIndent("DPCDDataBlock - Details:");
        DPCDDataBlock.printWithIndent(dPCDDataBlock.getDetails(), 4);
        System.out.println("");
        if (!dPCDDataBlock.isError()) {
            DPCDMessage dPCDMessage = dPCDDataBlock.aMessage;
            String string = "UNDEFINED";
            if (dPCDMessage instanceof DPCDRequestMessage) {
                string = "DPCDRequestMessage";
                DPCDRequestMessage dPCDRequestMessage = (DPCDRequestMessage)dPCDMessage;
                DPCDDataBlock.printWithIndent(string + " - Address:  '" + DPCDDataBlock.longAddressToHexString(dPCDRequestMessage.getAddress()) + "'");
            } else if (dPCDMessage instanceof DPCDReplyMessage) {
                string = "DPCDReplyMessage";
                DPCDReplyMessage dPCDReplyMessage = (DPCDReplyMessage)dPCDMessage;
                DPCDDataBlock.printWithIndent(string + " - Data an M-Value:  '" + dPCDReplyMessage.isDataMValue() + "'");
            } else {
                DPCDDataBlock.printWithIndent(string + " - UNKNOWN TYPE");
            }
        }
    }

    public static Integer[] getWorkingMessage() {
        Integer[] integerArray = null;
        if (sLastBlock != null) {
            integerArray = DPCDDataBlock.sLastBlock.aRawPacket;
        }
        return integerArray;
    }
}

